<?php include 'includes/header.php'; ?>

<div class="container py-5">
    <div class="row">
        <div class="col-md-6">
            <h2>Contact Us</h2>
            <p>Have questions? We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
            
            <div class="mt-4">
                <h4>Our Location</h4>
                <p>
                    123 Car Street<br>
                    Auto City, AC 12345<br>
                    United States
                </p>
                
                <h4>Contact Information</h4>
                <p>
                    <i class="fas fa-phone me-2"></i> (123) 456-7890<br>
                    <i class="fas fa-envelope me-2"></i> info@cardealer.com<br>
                    <i class="fas fa-clock me-2"></i> Mon - Sat: 9:00 AM - 6:00 PM
                </p>
                
                <h4>Follow Us</h4>
                <div class="social-links">
                    <a href="#" class="text-dark me-3"><i class="fab fa-facebook fa-2x"></i></a>
                    <a href="#" class="text-dark me-3"><i class="fab fa-twitter fa-2x"></i></a>
                    <a href="#" class="text-dark me-3"><i class="fab fa-instagram fa-2x"></i></a>
                    <a href="#" class="text-dark"><i class="fab fa-linkedin fa-2x"></i></a>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">Send us a Message</h3>
                    
                    <form action="submit_contact.php" method="POST">
                        <div class="mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Subject</label>
                            <input type="text" class="form-control" name="subject" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Message</label>
                            <textarea class="form-control" name="message" rows="5" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Send Message</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Google Map -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card">
                <div class="card-body p-0">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d387193.30596073366!2d-74.25986548248684!3d40.69714941932609!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c24fa5d33f083b%3A0xc80b8f06e177fe62!2sNew%20York%2C%20NY%2C%20USA!5e0!3m2!1sen!2s!4v1647043435129!5m2!1sen!2s" 
                        width="100%" 
                        height="450" 
                        style="border:0;" 
                        allowfullscreen="" 
                        loading="lazy">
                    </iframe>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 